dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 200, 220, "assets/images/table/castle_6", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 3, 190, 360, "assets/images/table/castle", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 3, 400, 360, "assets/images/table/castle", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 4, 6, 200, 485, "assets/images/table/castle_6", "assets/images/food/item_mark4", "R" );

numServers = 1;

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.7

--Group 1
guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female04;
guest.likes={female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 2000);


--Group 2
guest = LManager.GenGuest(male01);
guest.matchType = female03;
guest.percentRequestMusic = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.likes={female04};
guest.matchType = table1;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 8, 20000);


--Group 3
guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male01;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 30000);


--Group 4
guest = LManager.GenGuest(uncle);
guest.matchType = male01;
guest.percentRequestCoffee = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 11, 50000);


--Group 5
guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 14, 80000);
--Original 11k

--Group 6
guest = LManager.GenGuest(male02);
guest.matchType = female02;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male03;
guest.percentRequestTissue = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female04;
guest.percentRequestMusic = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 20, 130000)


--Group 6
guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 21, 160000)

--Group 6
guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table4;
guest.percentRequestCoffee = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 23, 180000)


--Group 7
guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female01;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(24, 28, 200000)


LManager:AdjustGuestTolerance(140);

LManager:AddReseatingRequestForGuest( 20000, male02 );
LManager:AddReseatingRequestForGuest( 60000, aunt );
LManager:AddReseatingRequestForGuest( 120000, female03 );
LManager:AddReseatingRequestForGuest( 180000, male01 );
LManager:AddReseatingRequestForGuest( 250000, male01 );

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 90000 );

LManager:SetLevelSetting ("bridesmaidsDelay", 150000);
LManager:SetLevelSetting ("bridesmaidChance", 100);

LManager:SetLevelSetting ("speakerDelay", 190000);
LManager:SetLevelSetting ("speakerChance", 80);

-- Set up the Level Settings
LManager:SetLevelNumber(5,7);
LManager:SetLevelScores(14000, 16500);
LManager:SetLevelTime(400000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_2.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );